using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Data;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	#region Header

		//<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		//<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		//<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		//<Developers>
		//	<Developer>Margaret Jablonski</Developer>
		//</Developers>
		//<SiteName>Hines OIFO</SiteName>
		//<CreationDate>8/13/2004</CreationDate>
		//<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		//<summary></summary>

		#endregion

	/// <summary>
	/// Class FrmTransfusionRequirementsReport
	/// </summary>
	public class FrmTransfusionRequirementsReport : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables
		private BOL.VbecsReport _report;
		private DataTable _dtReportData;
		#endregion

		#region Form Controls
		private System.Windows.Forms.PrintDialog printDialog1;
		private System.Windows.Forms.Button btnClose;
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.GroupBox grpImage;
        private System.Windows.Forms.PictureBox picImage;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvTransfusionRequirements;
		private System.ComponentModel.IContainer components = null;
		#endregion

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="report"></param>
		/// <param name="reportData"></param>
		public FrmTransfusionRequirementsReport(BOL.VbecsReport report, DataTable reportData)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			this._report = report;
			this._dtReportData = reportData;
			CreateReport();
			SetComponentProperties();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmTransfusionRequirementsReport));
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.btnClose = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.picImage = new System.Windows.Forms.PictureBox();
            this.rvTransfusionRequirements = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.TabIndex = 3;
            this.vbecsLogo1.Title = "Transfusion Requirements Report";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 5;
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // btnClose
            // 
            this.btnClose.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnClose.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnClose.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnClose.Location = new System.Drawing.Point(564, 448);
            this.btnClose.Name = "btnClose";
            this.btnClose.Size = new System.Drawing.Size(75, 23);
            this.btnClose.TabIndex = 2;
            this.btnClose.Text = "&Close";
            this.btnClose.Click += new System.EventHandler(this.btnClose_Click);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(484, 448);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 1;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.picImage);
            this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 412);
            this.grpImage.TabIndex = 4;
            this.grpImage.TabStop = false;
            // 
            // picImage
            // 
            this.picImage.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
            this.picImage.Location = new System.Drawing.Point(4, 12);
            this.picImage.Name = "picImage";
            this.picImage.Size = new System.Drawing.Size(45, 45);
            this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picImage.TabIndex = 0;
            this.picImage.TabStop = false;
            // 
            // rvTransfusionRequirements
            // 
            this.rvTransfusionRequirements.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvTransfusionRequirements.Location = new System.Drawing.Point(60, 37);
            this.rvTransfusionRequirements.Name = "rvTransfusionRequirements";
            this.rvTransfusionRequirements.Size = new System.Drawing.Size(579, 405);
            this.rvTransfusionRequirements.TabIndex = 6;
            this.rvTransfusionRequirements.RenderingComplete += new Microsoft.Reporting.WinForms.RenderingCompleteEventHandler(this.rvTransfusionRequirements_RenderingComplete);
            this.rvTransfusionRequirements.RenderingBegin += new System.ComponentModel.CancelEventHandler(this.rvTransfusionRequirements_RenderingBegin);
            // 
            // FrmTransfusionRequirementsReport
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnClose;
            this.ClientSize = new System.Drawing.Size(642, 473);
            this.Controls.Add(this.rvTransfusionRequirements);
            this.Controls.Add(this.btnClose);
            this.Controls.Add(this.btnPrint);
            this.Controls.Add(this.grpImage);
            this.hlphelpChm.SetHelpKeyword(this, "Transfusion_Requirements_Report.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(600, 450);
            this.Name = "FrmTransfusionRequirementsReport";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Transfusion Requirements Report";
            this.Load += new System.EventHandler(this.FrmTransfusionRequirementsReport_Load);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnClose, 0);
            this.Controls.SetChildIndex(this.rvTransfusionRequirements, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		#region Methods 
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC089.FrmTransfusionRequirementsReport());
            BOL.VbecsReport.SetUpReportButtons(this.rvTransfusionRequirements);
        }

		private void CreateReport()
		{
#if DEBUG
            //this._dtReportData.WriteXml("e:\\temp\\TransfusionRequirementsDataSet.xml", XmlWriteMode.WriteSchema);
#endif
			string reportCriteria = "Date Range: ";
			if (this._report.StartDate == DateTime.MinValue)
			{
				reportCriteria += "N/A (Cumulative Report)";
			}
			else
			{
				reportCriteria += Common.VBECSDateTime.FormatDateString(this._report.StartDate);
				reportCriteria += " - ";
				reportCriteria += Common.VBECSDateTime.FormatDateString(this._report.EndDate);
			}

			DataSet dsHeader =  BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
			DataSet dsFooter = BOL.VbecsReport.GetReportFooter(reportCriteria);

            ReportDataSource reportSourceMain = new ReportDataSource();
            reportSourceMain.Name = "TransfusionRequirementsDataSet";
            reportSourceMain.Value = this._dtReportData;

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionRequirements.TransfusionRequirementsReport.rdlc");

            this.rvTransfusionRequirements.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvTransfusionRequirements.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvTransfusionRequirements.LocalReport.DataSources.Add(reportSourceMain);
            this.rvTransfusionRequirements.LocalReport.LoadReportDefinition(stream);

            this.rvTransfusionRequirements.RefreshReport();

		}

		#endregion
	
		#region Events / Event Handlers

		private void btnClose_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
            //CR 3449
            try
            {
                this.rvTransfusionRequirements.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

		#endregion

        private void FrmTransfusionRequirementsReport_Load(object sender, EventArgs e)
        {

            this.rvTransfusionRequirements.RefreshReport();
        }

        /// <summary>
        /// CR 3581
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void rvTransfusionRequirements_RenderingBegin(object sender, CancelEventArgs e)
        {
            this.btnPrint.Enabled = false;
        }

        /// <summary>
        /// CR 3581
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void rvTransfusionRequirements_RenderingComplete(object sender, RenderingCompleteEventArgs e)
        {
            this.btnPrint.Enabled = true;
        }
	}
}

